<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBanners extends CPlugin{
	
	var $tplvars; 

	function CBanners() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;	
		
		parent::DoEvents();

		if ($_GET["mod"] == "banners") {
			$this->Redirect();
		}		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"banners"			=> "banners.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getBanners($zone) {
		global $base , $_CONF;

		$this->__init();

		$zone = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:banners_cats']} 
			WHERE 
				cat_id = {$zone} AND 
				cat_status = 1 
		");

		if (!is_array($zone)) {
			return "";
		}

		$now = time();

		$items = $this->db->QFetchRowArray("
			SELECT  * FROM 
				{$this->tables['plugin:banners_items']} 
			WHERE
				item_cat={$zone[cat_id]} AND 
				item_status = 1 AND 
				(item_max_show = 0 OR ( item_max_show > 0 AND item_max_show < item_shows )) AND 
				item_date_start < %d AND
				(item_date_end = 0 OR (item_date_end > 0 AND item_date_end > %d))
			LIMIT 
				{$zone[cat_show]}
		",
			array(
				$now , 
				$now 
			)
		);

/*

*/

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {

			switch ($val["item_type"]) {
				case "2":
					$items[$key]["content"] = $this->_t("banners")->blockReplace("HTML" , $val);
				break;

				case "1":
					$val["link"] = $_CONF["url"] . "b/" . $val["item_id"];
					$items[$key]["content"] = $this->_t("banners")->blockReplace("Image" , $val);
				break;

			}


			//update and log shows 
			$this->LogAction($val , 2);
			
		}
		
		
		return $base->html->table(
			$this->_t("banners") , 
			"",
			$items
		);
		
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LogAction($link , $type) {
		global $_CONF;

		//check for existing log
		$log = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:banners_log']}
			WHERE 
				log_type = %d AND 
				log_url = {$link[item_id]} AND 
				log_remote_addr LIKE '%s'
			",
			array(
				$type,
				$_SERVER["REMOTE_ADDR"]
			)
		);


		switch ($type) {
			case 1:

				if (is_array($log)) {
					$link["item_clicks"] ++;
				} else {
					$link["item_clicks"] ++;
					$link["item_unique_clicks"] ++;
				}

				$page = $_SERVER["HTTP_REFERER"];

			break;

			case 2:
				if (is_array($log)) {
					$link["item_shows"] ++;
				} else {
					$link["item_shows"] ++;
					$link["item_unique_shows"] ++;
				}

				$page = substr($_CONF["url"] , 0 , -1) . $_SERVER["REQUEST_URI"];

			break;
		}

		//update the number of shows and clicks
		$this->db->QueryUpdate(
			$this->tables["plugin:banners_items"], 
			array(
				"item_shows"		=> $link["item_shows"],
				"item_unique_shows"	=> $link["item_unique_shows"],
				"item_clicks"		=> $link["item_clicks"],
				"item_unique_clicks"=> $link["item_unique_clicks"],
			),
			"item_id={$link[item_id]}"
		);

		$this->db->QueryInsert(
			$this->tables["plugin:banners_log"],
			array(
				"log_date"			=> time(),
				"log_type"			=> $type,
				"log_url"			=> $link["item_id"],	
				"log_user_agent"	=> $_SERVER["HTTP_USER_AGENT"],
				"log_language"		=> $_SERVER["HTTP_ACCEPT_LANGUAGE"],
				"log_remote_addr"	=> $_SERVER["REMOTE_ADDR"],
				"log_referer"		=> $_SERVER["HTTP_REFERER"],
				"log_page"			=> $page,
			)
		);

	}
	


	function onGlobalHooksExecute($module) {
		global $_LANG_ID , $_TSM , $base;

		if ($this->added) {
			return "";
		}
		

		$this->added = true;


		//shortcodes
		$this->plugins["shortcodes"]->dynamic[] = array(
			"code"	=> 'adzone',
			"method"	=> array(&$this, "shortcode")
		);

	}




	function ShortCode($matches) {
	
		$banners = $this->getBanners($matches["vars"]["attr"]);

		return $this->_t("banners")->BlockReplace(
			"ShortCode",
			array(
				"content"	=> $banners
			)
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Redirect() {

		$link = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:banners_items']}
			WHERE 
				item_id = %d
			",
			array(
				$_GET["link"]
			)
		);

		if (!is_array($link)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		//update the stats

		$link["item_link"] = $this->plugins["modules"]->BuildLink(array(
			"type"	=> $link["item_link_type"],
			"link"	=> $link["item_link_link"],
			"module"=> $link["item_link_module"],
			"global"=> $link["item_link_global"]
		));

		$this->LogAction($link , 1);
		
		header ( "Location: {$link[item_link]} ", true, 301);
		exit();

		

	}

}

?>